/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /page/plug页面函数(硬件)
*
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.05.19
*      内容 : 所有代码
************************************************************************************************/
/* exported tc_plug_init_page */
/* exported tc_plug_open_plug */

/* global $ */

// 页面层级
// 顶层
var obj_plug_iframe_top = "";
// main层
var obj_plug_iframe_sub_main = "";
// 子页面层
var obj_plug_iframe_child_page = "";
// 子页面dom层 默认去界面第一层
var obj_plug_html_child_page = "";
// 子页面方面变量定义层
var obj_plug_window_child_page = "";

// 应显示的数据
var arr_jungle_data = [];


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试插件界面渲染功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-19
 *       内容 : 所有代码
************************************************************************************************/
function tc_plug_init_page(callback) {
    mc_plug_clear_iframe_page();
    mc_plug_jungle_open_subpage(0, function () {
        arr_jungle_data = mc_plug_get_send_data_json();

        var ui_cnt = arr_jungle_data[0].length;
        var b_if_remote = arr_jungle_data[1];
        var ui_jungle_cnt = 0;

        for (var idx = 0; idx < ui_cnt; idx++) {
            if (!b_if_remote) {
                if ("0" !== arr_jungle_data[1][idx][2]) {
                    ui_jungle_cnt += 1;
                }
            } else {
                ui_jungle_cnt = ui_cnt;
                break;
            }
        }

        var html_page = obj_plug_html_child_page.getElementsByClassName("each_box");
        var ui_page_cnt = html_page.length;

        if (ui_page_cnt === ui_jungle_cnt) {
            callback("1", "渲染正确");
        } else {
            callback("0", "渲染错误,数量不一致");
        }
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试打开的插件
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-19
 *       内容 : 所有代码
************************************************************************************************/
function tc_plug_open_plug(callback) {
    mc_plug_clear_iframe_page();
    mc_plug_jungle_open_subpage(0, function () {
        arr_jungle_data = mc_plug_get_send_data_json();
        // 点击第一个
        var str_plug_name;

        str_plug_name = arr_jungle_data[0][0][0];
        obj_plug_window_child_page.mc_use_plug(str_plug_name, function (err) {
            if ("0x00000000" === err || !err) {
                callback("1", "打开正确");
            } else {
                callback("0", "打开错误,接口错误码 : " + err);
            }
            return;
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取已存的发送数据
 * 参数:
 *    @param {Promise<Array>}  arr 表格数据

 * 返回：
 *   @returns {Promise<str>}    表达式 矫正数据
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.5.10
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_plug_get_send_data_json() {
    var arr_json = document.getElementById("tifrem_led").contentDocument.getElementById("iframe_subpage").contentWindow.g_str_test_data;

    return arr_json;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清空所有子页面 和弹框
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-19
 *       内容 : 所有代码
************************************************************************************************/
function mc_plug_clear_iframe_page() {
    obj_plug_iframe_top = document.getElementById("tifrem_led");
    obj_plug_iframe_sub_main = obj_plug_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_plug_iframe_child_page = obj_plug_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    var ui_iframe_page_cnt = obj_plug_iframe_child_page.length;

    // 提示弹框
    var arr_dialog_html = obj_plug_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 < arr_dialog_html.length) {
        obj_plug_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        obj_plug_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    for (var idx = 0; idx < ui_iframe_page_cnt; idx++) {
        obj_plug_iframe_child_page[0].remove();
        obj_plug_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断是否打开第三层子页面 以防同时测试多个时数据不对
 * 参数:
 *    @param { Promise<string> } idx_page 需打开第几个iframe界面
 *    @param { Promise<fun_callback> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-19
 *       内容 : 所有代码
************************************************************************************************/
function mc_plug_jungle_open_subpage(idx_page, callback) {
    var ui_iframe_len = obj_plug_iframe_child_page.length;

    if (0 === ui_iframe_len) {
        // 点击进入显示控制界面
        $(obj_plug_iframe_sub_main).contents().find("#mc_hardware_write").click();
        setTimeout(() => {
            obj_plug_html_child_page = obj_plug_iframe_child_page[0].getElementsByTagName("iframe")[0].contentDocument;
            obj_plug_window_child_page = obj_plug_iframe_child_page[0].getElementsByTagName("iframe")[0].contentWindow;
            callback();
        }, 1000);
        return;
    }
    obj_plug_html_child_page = obj_plug_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentDocument;
    obj_plug_window_child_page = obj_plug_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentWindow;
    callback();
    return;
}
